/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.cglib;

import com.livk.commons.cglib.AbstractClassGenerator;
import com.livk.commons.cglib.BeanMapEmitter;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.asm.ClassVisitor;
import org.springframework.cglib.core.Customizer;
import org.springframework.cglib.core.KeyFactory;
import org.springframework.cglib.core.ReflectUtils;

public abstract class BeanMap
implements Map<String, Object> {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;

    protected BeanMap() {
    }

    protected BeanMap(Object bean) {
        this.setBean(bean);
    }

    public static <T> BeanMap create(T bean) {
        Generator gen = new Generator();
        gen.setBean(bean);
        return gen.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class<?> getPropertyType(String var1);

    @Override
    public Object get(Object key) {
        return this.get(this.bean, key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.put(this.bean, key, value);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (String s : this.keySet()) {
            Object v = this.get(s);
            if ((value != null || v != null) && (value == null || !value.equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        for (String string : t.keySet()) {
            this.put(string, t.get(string));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (Object key : this.keySet()) {
            Object v2;
            if (!other.containsKey(key)) {
                return false;
            }
            Object v1 = this.get(key);
            if (Objects.equals(v1, v2 = other.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = 0;
        for (Object key : this.keySet()) {
            Object value = this.get(key);
            code += (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
        return code;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            copy.put(key, this.get(key));
        }
        return Collections.unmodifiableMap(copy).entrySet();
    }

    @Override
    public Collection<Object> values() {
        Set keys = this.keySet();
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (String key : keys) {
            values.add(this.get(key));
        }
        return Collections.unmodifiableCollection(values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            sb.append(key);
            sb.append('=');
            sb.append(this.get(key));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    public static class Generator<T>
    extends AbstractClassGenerator<T> {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(BeanMap.class.getName());
        private final BeanMapKey<T> KEY_FACTORY = (BeanMapKey)KeyFactory.create(BeanMapKey.class, (Customizer)KeyFactory.CLASS_BY_NAME);
        private Object bean;
        private Class<T> beanClass;
        private int require;

        public Generator() {
            super(SOURCE);
        }

        public void setBean(Object bean) {
            this.bean = bean;
            if (bean != null) {
                this.beanClass = bean.getClass();
                this.setContextClass((Class)this.beanClass);
            }
        }

        public void setBeanClass(Class<T> beanClass) {
            this.beanClass = beanClass;
        }

        public void setRequire(int require) {
            this.require = require;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.beanClass);
        }

        public BeanMap create() {
            if (this.beanClass == null) {
                throw new IllegalArgumentException("Class of bean unknown");
            }
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(this.KEY_FACTORY.newInstance(this.beanClass, this.require));
        }

        public void generateClass(ClassVisitor v) throws Exception {
            new BeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        @Override
        protected Object firstInstance(Class<?> type) {
            return ((BeanMap)ReflectUtils.newInstance(type)).newInstance(this.bean);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }

        static interface BeanMapKey<T> {
            public T newInstance(Class<T> var1, int var2);
        }
    }
}

