/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.expression;

import com.livk.commons.expression.AbstractExpressionResolver;
import com.livk.commons.expression.Context;
import com.livk.commons.util.ObjectUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.env.Environment;
import org.springframework.expression.ExpressionException;

public abstract class CacheExpressionResolver<EXPRESSION>
extends AbstractExpressionResolver {
    private final Map<String, EXPRESSION> expressionCache = new ConcurrentHashMap<String, EXPRESSION>(256);
    private Environment environment;

    @Override
    public <T> T evaluate(String value, Context context, Class<T> returnType) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        try {
            EXPRESSION expression;
            value = this.wrapIfNecessary(value);
            if (this.environment != null) {
                value = this.environment.resolvePlaceholders(value);
            }
            if ((expression = this.expressionCache.get(value)) == null) {
                expression = this.compile(value);
                this.expressionCache.put(value, expression);
            }
            return this.calculate(expression, context, returnType);
        }
        catch (Throwable ex) {
            throw new ExpressionException("Expression parsing failed", ex);
        }
    }

    protected String wrapIfNecessary(String expression) {
        return expression;
    }

    protected abstract EXPRESSION compile(String var1) throws Throwable;

    protected abstract <T> T calculate(EXPRESSION var1, Context var2, Class<T> var3) throws Throwable;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

