/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.expression;

import com.google.common.collect.Maps;
import com.livk.commons.expression.Context;
import com.livk.commons.expression.ContextFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.util.Assert;

class DefaultContextFactory
implements ContextFactory {
    private final Map<Method, String[]> parameterNamesCache = new ConcurrentHashMap<Method, String[]>(64);
    private final ParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();

    DefaultContextFactory() {
    }

    @Override
    public Context create(Method method, Object[] args) {
        Assert.notNull((Object)method, (String)"method not be null");
        String[] parameterNames = this.parameterNamesCache.computeIfAbsent(method, arg_0 -> ((ParameterNameDiscoverer)this.discoverer).getParameterNames(arg_0));
        Assert.notNull((Object)parameterNames, (String)"\u53c2\u6570\u5217\u8868\u4e0d\u80fd\u4e3anull");
        HashMap map = Maps.newHashMapWithExpectedSize((int)parameterNames.length);
        if (args != null && parameterNames.length == args.length) {
            for (int i = 0; i < parameterNames.length; ++i) {
                map.put(parameterNames[i], args[i]);
            }
        }
        return new Context(map);
    }
}

