/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.expression.spring;

import com.livk.commons.expression.Context;
import com.livk.commons.expression.ConverterExpressionResolver;
import com.livk.commons.expression.ExpressionResolver;
import java.util.Map;
import org.springframework.context.expression.BeanExpressionContextAccessor;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.expression.spel.support.StandardTypeLocator;

public class SpringExpressionResolver
extends ConverterExpressionResolver<EvaluationContext, Expression>
implements ExpressionResolver {
    private final ExpressionParser expressionParser;
    private final ParserContext beanExpressionParserContext = new TemplateParserContext();

    public SpringExpressionResolver() {
        this.expressionParser = new SpelExpressionParser();
    }

    public SpringExpressionResolver(ClassLoader beanClassLoader) {
        this.expressionParser = new SpelExpressionParser(new SpelParserConfiguration(null, beanClassLoader));
    }

    @Override
    protected Expression compile(String value) {
        return this.expressionParser.parseExpression(value, this.beanExpressionParserContext);
    }

    @Override
    protected String wrapIfNecessary(String expression) {
        if (!expression.contains("#")) {
            return expression;
        }
        if (!expression.contains("#{")) {
            return "#{" + expression + "}";
        }
        return expression;
    }

    @Override
    protected EvaluationContext transform(Context context) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanExpressionContextAccessor());
        evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        evaluationContext.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        evaluationContext.setTypeLocator((TypeLocator)new StandardTypeLocator());
        evaluationContext.setTypeConverter((TypeConverter)new StandardTypeConverter());
        evaluationContext.setVariables((Map)context);
        return evaluationContext;
    }

    @Override
    protected <T> T calculate(Expression expression, EvaluationContext context, Class<T> returnType) {
        return (T)expression.getValue(context, returnType);
    }
}

