/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.http;

import com.livk.commons.http.support.OkHttpClientHttpRequestFactory;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class RestTemplateConfiguration {
    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Configuration(enforceUniqueMethods=false)
    @ConditionalOnClass(value={OkHttpClient.class})
    public static class OkHttpClientConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={OkHttpClient.class})
        public RestTemplateCustomizer restTemplateCustomizer() {
            ConnectionPool pool = new ConnectionPool(200, 300L, TimeUnit.SECONDS);
            OkHttpClientHttpRequestFactory requestFactory = new OkHttpClientHttpRequestFactory().connectionPool(pool).connectTimeout(3L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS);
            return restTemplate -> restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        }

        @Bean
        @ConditionalOnBean(value={OkHttpClient.class})
        public RestTemplateCustomizer restTemplateCustomizer(OkHttpClient okHttpClient) {
            return restTemplate -> restTemplate.setRequestFactory((ClientHttpRequestFactory)new OkHttpClientHttpRequestFactory(okHttpClient));
        }
    }
}

