/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.DefaultSslContextSpec;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.logging.AdvancedByteBufFormat;

@AutoConfiguration(after={WebClientAutoConfiguration.class})
@ConditionalOnClass(value={WebClient.class})
public class WebClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(WebClient.Builder builder) {
        return builder.build();
    }

    @AutoConfiguration
    @ConditionalOnClass(value={HttpClient.class})
    public static class ReactorClientConfiguration {
        @Bean
        public WebClientCustomizer reactorClientWebClientCustomizer(ReactorResourceFactory reactorResourceFactory) {
            Function<HttpClient, HttpClient> function = httpClient -> (HttpClient)((HttpClient)((HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)3000)).wiretap(WebClient.class.getName(), LogLevel.DEBUG, AdvancedByteBufFormat.TEXTUAL, StandardCharsets.UTF_8)).responseTimeout(Duration.ofSeconds(15L)).secure(sslContextSpec -> sslContextSpec.sslContext((SslProvider.ProtocolSslContextSpec)DefaultSslContextSpec.forClient().configure(builder -> builder.trustManager(InsecureTrustManagerFactory.INSTANCE)))).doOnConnected(connection -> connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(20)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(20)));
            ReactorClientHttpConnector connector = new ReactorClientHttpConnector(reactorResourceFactory, function);
            return webClientBuilder -> webClientBuilder.clientConnector((ClientHttpConnector)connector);
        }
    }
}

