/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.http.support;

import com.livk.commons.http.support.OkHttpClientHttpRequest;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class OkHttpClientHttpRequestFactory
implements ClientHttpRequestFactory,
DisposableBean {
    private OkHttpClient client;
    private final boolean defaultClient;

    public OkHttpClientHttpRequestFactory() {
        this.client = new OkHttpClient();
        this.defaultClient = true;
    }

    public OkHttpClientHttpRequestFactory(OkHttpClient client) {
        Assert.notNull((Object)client, (String)"OkHttpClient must not be null");
        this.client = client;
        this.defaultClient = false;
    }

    public OkHttpClientHttpRequestFactory readTimeout(long readTimeout, TimeUnit unit) {
        this.client = this.client.newBuilder().readTimeout(readTimeout, unit).build();
        return this;
    }

    public OkHttpClientHttpRequestFactory readTimeout(Duration readTimeout) {
        this.client = this.client.newBuilder().readTimeout(readTimeout).build();
        return this;
    }

    public OkHttpClientHttpRequestFactory writeTimeout(long writeTimeout, TimeUnit unit) {
        this.client = this.client.newBuilder().writeTimeout(writeTimeout, unit).build();
        return this;
    }

    public OkHttpClientHttpRequestFactory writeTimeout(Duration writeTimeout) {
        this.client = this.client.newBuilder().writeTimeout(writeTimeout).build();
        return this;
    }

    public OkHttpClientHttpRequestFactory connectTimeout(long connectTimeout, TimeUnit unit) {
        this.client = this.client.newBuilder().connectTimeout(connectTimeout, unit).build();
        return this;
    }

    public OkHttpClientHttpRequestFactory connectTimeout(Duration connectTimeout) {
        this.client = this.client.newBuilder().connectTimeout(connectTimeout).build();
        return this;
    }

    public OkHttpClientHttpRequestFactory connectionPool(ConnectionPool connectionPool) {
        OkHttpClient.Builder builder = this.client.newBuilder();
        builder.setConnectionPool$okhttp(connectionPool);
        this.client = builder.build();
        return this;
    }

    @NonNull
    public ClientHttpRequest createRequest(@NonNull URI uri, @NonNull HttpMethod httpMethod) {
        return new OkHttpClientHttpRequest(this.client, uri, httpMethod);
    }

    public void destroy() throws IOException {
        if (this.defaultClient) {
            Cache cache = this.client.cache();
            if (cache != null) {
                cache.close();
            }
            this.client.dispatcher().executorService().close();
            this.client.connectionPool().evictAll();
        }
    }
}

