/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.http.support;

import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class OkHttpClientHttpResponse
implements ClientHttpResponse {
    private final Response response;
    @Nullable
    private volatile HttpHeaders headers;

    public OkHttpClientHttpResponse(Response response) {
        Assert.notNull((Object)response, (String)"Response must not be null");
        this.response = response;
    }

    @NonNull
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf((int)this.response.code());
    }

    @NonNull
    public String getStatusText() {
        return this.response.message();
    }

    @NonNull
    public InputStream getBody() {
        ResponseBody body = this.response.body();
        return body != null ? body.byteStream() : InputStream.nullInputStream();
    }

    @NonNull
    public HttpHeaders getHeaders() {
        HttpHeaders headers = this.headers;
        if (headers == null) {
            headers = new HttpHeaders();
            for (String headerName : this.response.headers().names()) {
                for (String headerValue : this.response.headers(headerName)) {
                    headers.add(headerName, headerValue);
                }
            }
            this.headers = headers;
        }
        return headers;
    }

    public void close() {
        ResponseBody body = this.response.body();
        if (body != null) {
            body.close();
        }
    }
}

