/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.io;

import com.livk.commons.util.ObjectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.http.codec.multipart.Part;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class FileUtils
extends FileCopyUtils {
    public static void download(InputStream stream, String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists() || FileUtils.createNewFile(file)) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                FileChannel channel = fileOutputStream.getChannel();
                ReadableByteChannel readableByteChannel = Channels.newChannel(stream);
                ByteBuffer buffer = ByteBuffer.allocate(1024);
                while (readableByteChannel.read(buffer) != -1) {
                    buffer.flip();
                    channel.write(buffer);
                    buffer.clear();
                }
            }
        } else {
            throw new IOException();
        }
    }

    public static boolean createNewFile(File file) throws IOException {
        boolean flag = true;
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            flag = parentFile.mkdirs();
        }
        return flag && file.createNewFile();
    }

    public static String read(File file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            String string;
            try (BufferedReader reader = new BufferedReader(fileReader);){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
    }

    public static Mono<Part> getPartValues(String name, ServerWebExchange exchange) {
        return exchange.getMultipartData().mapNotNull(multiValueMap -> (Part)multiValueMap.getFirst((Object)name));
    }

    public static void gzipCompress(byte[] bytes, OutputStream outputStream) throws IOException {
        if (!ObjectUtils.isEmpty((Object)bytes)) {
            try (GZIPOutputStream stream = new GZIPOutputStream(outputStream);){
                stream.write(bytes);
            }
        }
    }

    public static byte[] gzipDecompress(InputStream inputStream) throws IOException {
        try (GZIPInputStream stream = new GZIPInputStream(inputStream);){
            byte[] byArray = FileUtils.copyToByteArray((InputStream)stream);
            return byArray;
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

