/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.jackson.core;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.livk.commons.beans.GenericWrapper;
import com.livk.commons.jackson.core.AbstractJacksonOps;
import com.livk.commons.jackson.core.JacksonOps;
import java.io.DataInput;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public final class JacksonSupport
extends AbstractJacksonOps
implements JacksonOps,
GenericWrapper<ObjectMapper> {
    private final ObjectMapper mapper;

    public JacksonSupport(ObjectMapper mapper) {
        super(mapper.getTypeFactory());
        this.mapper = mapper;
        this.mapper.registerModules(new Module[]{new JavaTimeModule()});
    }

    @Override
    public <T> T readValue(Object obj, JavaType type) {
        if (obj instanceof JsonParser) {
            JsonParser jsonParser = (JsonParser)obj;
            return (T)this.mapper.readValue(jsonParser, type);
        }
        if (obj instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)obj;
            return (T)this.mapper.treeToValue((TreeNode)jsonNode, type);
        }
        if (obj instanceof File) {
            File file = (File)obj;
            return (T)this.mapper.readValue(file, type);
        }
        if (obj instanceof URL) {
            URL url = (URL)obj;
            return (T)this.mapper.readValue(url, type);
        }
        if (obj instanceof String) {
            String json = (String)obj;
            return (T)this.mapper.readValue(json, type);
        }
        if (obj instanceof Reader) {
            Reader reader = (Reader)obj;
            return (T)this.mapper.readValue(reader, type);
        }
        if (obj instanceof InputStream) {
            InputStream inputStream = (InputStream)obj;
            return (T)this.mapper.readValue(inputStream, type);
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return (T)this.mapper.readValue(bytes, type);
        }
        if (obj instanceof DataInput) {
            DataInput dataInput = (DataInput)obj;
            return (T)this.mapper.readValue(dataInput, type);
        }
        throw new UnsupportedOperationException("Unsupported type: " + obj.getClass().getName());
    }

    @Override
    public String writeValueAsString(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str;
        }
        return this.mapper.writeValueAsString(obj);
    }

    @Override
    public byte[] writeValueAsBytes(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return str.getBytes();
        }
        return this.mapper.writeValueAsBytes(obj);
    }

    @Override
    public JsonNode readTree(Object obj) {
        if (obj instanceof JsonParser) {
            JsonParser jsonParser = (JsonParser)obj;
            return (JsonNode)this.mapper.readTree(jsonParser);
        }
        if (obj instanceof File) {
            File file = (File)obj;
            return this.mapper.readTree(file);
        }
        if (obj instanceof URL) {
            URL url = (URL)obj;
            return this.mapper.readTree(url);
        }
        if (obj instanceof String) {
            String json = (String)obj;
            return this.mapper.readTree(json);
        }
        if (obj instanceof Reader) {
            Reader reader = (Reader)obj;
            return this.mapper.readTree(reader);
        }
        if (obj instanceof InputStream) {
            InputStream inputStream = (InputStream)obj;
            return this.mapper.readTree(inputStream);
        }
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return this.mapper.readTree(bytes);
        }
        return this.mapper.valueToTree(obj);
    }

    @Override
    public <T> T convertValue(Object fromValue, JavaType javaType) {
        return (T)this.mapper.convertValue(fromValue, javaType);
    }

    @Override
    public ObjectMapper unwrap() {
        return this.mapper;
    }
}

