/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.jackson.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.livk.commons.jackson.support.NumberJsonFormat;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.Set;

public class NumberJsonSerializer
extends JsonSerializer<Number>
implements ContextualSerializer {
    private static final Set<Class<?>> SUPPORT_PRIMITIVE_CLASS = Set.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    private String format;

    public void serialize(Number value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(new DecimalFormat(this.format).format(value));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Class rawClass = property.getType().getRawClass();
        NumberJsonFormat jsonFormat = Optional.ofNullable((NumberJsonFormat)property.getAnnotation(NumberJsonFormat.class)).orElse((NumberJsonFormat)property.getContextAnnotation(NumberJsonFormat.class));
        if (Number.class.isAssignableFrom(rawClass) || this.simpleTypeSupport(rawClass)) {
            return new NumberJsonSerializer(jsonFormat.pattern());
        }
        return prov.findValueSerializer(property.getType(), property);
    }

    private boolean simpleTypeSupport(Class<?> rawClass) {
        return rawClass.isPrimitive() && SUPPORT_PRIMITIVE_CLASS.contains(rawClass);
    }

    public NumberJsonSerializer(String format) {
        this.format = format;
    }

    public NumberJsonSerializer() {
    }
}

