/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.jackson.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.livk.commons.jackson.core.JacksonSupport;
import com.livk.commons.jackson.util.TypeFactoryUtils;
import java.util.List;
import java.util.Map;

public final class JsonMapperUtils {
    private static final JacksonSupport JSON = new JacksonSupport((ObjectMapper)new JsonMapper());

    public static <T> T readValue(Object obj, Class<T> type) {
        return JSON.readValue(obj, type);
    }

    public static <T> T readValue(Object obj, JavaType type) {
        return JSON.readValue(obj, type);
    }

    public static <T> T readValue(Object obj, TypeReference<T> typeReference) {
        return JSON.readValue(obj, typeReference);
    }

    public static String writeValueAsString(Object obj) {
        return JSON.writeValueAsString(obj);
    }

    public static byte[] writeValueAsBytes(Object obj) {
        return JSON.writeValueAsBytes(obj);
    }

    public static <T> List<T> readValueList(Object obj, Class<T> type) {
        CollectionType collectionType = TypeFactoryUtils.collectionType(type);
        return (List)JSON.readValue(obj, (JavaType)collectionType);
    }

    public static <K, V> Map<K, V> readValueMap(Object obj, Class<K> keyClass, Class<V> valueClass) {
        MapType mapType = TypeFactoryUtils.mapType(keyClass, valueClass);
        return (Map)JSON.readValue(obj, (JavaType)mapType);
    }

    public static JsonNode readTree(Object obj) {
        return JSON.readTree(obj);
    }

    public static <T> T convertValue(Object fromValue, Class<T> type) {
        return JSON.convertValue(fromValue, type);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> typeReference) {
        return JSON.convertValue(fromValue, typeReference);
    }

    public static <T> T convertValue(Object fromValue, JavaType javaType) {
        return JSON.convertValue(fromValue, javaType);
    }

    public static <T> List<T> convertValueList(Object fromValue, Class<T> type) {
        CollectionType collectionType = TypeFactoryUtils.collectionType(type);
        return (List)JSON.convertValue(fromValue, (JavaType)collectionType);
    }

    public static <K, V> Map<K, V> convertValueMap(Object fromValue, Class<K> keyClass, Class<V> valueClass) {
        MapType mapType = TypeFactoryUtils.mapType(keyClass, valueClass);
        return (Map)JSON.convertValue(fromValue, (JavaType)mapType);
    }

    private JsonMapperUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

