/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.jackson.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Streams;
import com.livk.commons.jackson.util.TypeFactoryUtils;
import com.livk.commons.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JsonNodeUtils {
    public static final TypeReference<Set<String>> STRING_SET = new TypeReference<Set<String>>(){};
    public static final TypeReference<Map<String, Object>> STRING_OBJECT_MAP = new TypeReference<Map<String, Object>>(){};

    public static String findStringValue(JsonNode jsonNode, String fieldName) {
        if (jsonNode == null) {
            return null;
        }
        JsonNode value = jsonNode.findValue(fieldName);
        return value != null && value.isTextual() ? value.asText() : null;
    }

    public static JsonNode findObjectNode(JsonNode jsonNode, String fieldName) {
        if (jsonNode == null) {
            return null;
        }
        JsonNode value = jsonNode.findValue(fieldName);
        return value != null && value.isObject() ? value : null;
    }

    public static <T> T findValue(JsonNode jsonNode, String fieldName, TypeReference<T> valueTypeReference, ObjectMapper mapper) {
        JavaType javaType = TypeFactoryUtils.javaType(valueTypeReference);
        return JsonNodeUtils.findValue(jsonNode, fieldName, javaType, mapper);
    }

    public static <T> T findValue(JsonNode jsonNode, String fieldName, Class<T> type, ObjectMapper mapper) {
        JavaType javaType = TypeFactoryUtils.javaType(type);
        return JsonNodeUtils.findValue(jsonNode, fieldName, javaType, mapper);
    }

    public static <T> T findValue(JsonNode jsonNode, String fieldName, JavaType javaType, ObjectMapper mapper) {
        if (jsonNode == null) {
            return null;
        }
        JsonNode value = jsonNode.findValue(fieldName);
        return (T)(value != null && value.isContainerNode() ? mapper.convertValue((Object)value, javaType) : null);
    }

    public static JsonNode findNodeFirst(JsonNode jsonNode, String nodeName) {
        if (jsonNode == null || ObjectUtils.isEmpty((Object)nodeName)) {
            return null;
        }
        if (jsonNode.isArray()) {
            Iterator elements = jsonNode.elements();
            while (elements.hasNext()) {
                JsonNode result = JsonNodeUtils.findNodeFirst((JsonNode)elements.next(), nodeName);
                if (result == null) continue;
                return result;
            }
        } else {
            Iterator iterator = jsonNode.fieldNames();
            while (iterator.hasNext()) {
                JsonNode result;
                String node = (String)iterator.next();
                if (node.equals(nodeName)) {
                    return jsonNode.get(nodeName);
                }
                JsonNode child = jsonNode.get(node);
                if (!child.isContainerNode() || (result = JsonNodeUtils.findNodeFirst(child, nodeName)) == null) continue;
                return result;
            }
        }
        return null;
    }

    public static List<JsonNode> findNodeAll(JsonNode jsonNode, String nodeName) {
        if (jsonNode == null || ObjectUtils.isEmpty((Object)nodeName)) {
            return Collections.emptyList();
        }
        ArrayList<JsonNode> jsonNodeList = new ArrayList<JsonNode>();
        if (jsonNode.isArray()) {
            Iterator elements = jsonNode.elements();
            while (elements.hasNext()) {
                List<JsonNode> firstAll = JsonNodeUtils.findNodeAll((JsonNode)elements.next(), nodeName);
                jsonNodeList.addAll(firstAll);
            }
        } else {
            Iterator iterator = jsonNode.fieldNames();
            while (iterator.hasNext()) {
                String node = (String)iterator.next();
                if (node.equals(nodeName)) {
                    jsonNodeList.add(jsonNode.get(nodeName));
                    continue;
                }
                JsonNode child = jsonNode.get(node);
                if (!child.isContainerNode()) continue;
                List<JsonNode> firstAll = JsonNodeUtils.findNodeAll(child, nodeName);
                jsonNodeList.addAll(firstAll);
            }
        }
        return jsonNodeList;
    }

    public static JsonNode findNode(JsonNode jsonNode, String nodePath) {
        if (jsonNode == null || ObjectUtils.isEmpty((Object)nodePath)) {
            return null;
        }
        int index = nodePath.indexOf(46);
        if (jsonNode.isArray()) {
            int range = Integer.parseInt(nodePath.substring(0, index));
            Iterator elements = jsonNode.elements();
            JsonNode node = (JsonNode)Streams.stream((Iterator)elements).toList().get(range);
            return JsonNodeUtils.findNode(node, nodePath.substring(index + 1));
        }
        Iterator iterator = jsonNode.fieldNames();
        while (iterator.hasNext()) {
            String childNode;
            JsonNode result;
            JsonNode child;
            String node = (String)iterator.next();
            if (index <= 0) {
                if (!node.equals(nodePath)) continue;
                return jsonNode.get(nodePath);
            }
            String parentNode = nodePath.substring(0, index);
            if (!node.equals(parentNode) || !(child = jsonNode.get(node)).isContainerNode() || (result = JsonNodeUtils.findNode(child, childNode = nodePath.substring(index + 1))) == null) continue;
            return result;
        }
        return null;
    }

    private JsonNodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

