/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.jackson.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.ResolvableType;

public final class TypeFactoryUtils {
    public static TypeFactory instance() {
        return TypeFactory.defaultInstance();
    }

    public static JavaType javaType(Class<?> targetClass) {
        return TypeFactoryUtils.instance().constructType(targetClass);
    }

    public static JavaType javaType(Class<?> targetClass, Class<?> ... generics) {
        return TypeFactoryUtils.instance().constructParametricType(targetClass, (Class[])generics);
    }

    public static JavaType javaType(Class<?> targetClass, JavaType ... generics) {
        return TypeFactoryUtils.instance().constructParametricType(targetClass, generics);
    }

    public static JavaType javaType(TypeReference<?> typeReference) {
        return TypeFactoryUtils.instance().constructType(typeReference);
    }

    public static JavaType javaType(ResolvableType resolvableType) {
        Class rawClass = resolvableType.getRawClass();
        Type type2 = resolvableType.getType();
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            JavaType[] javaTypes = (JavaType[])Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> TypeFactoryUtils.javaType(ResolvableType.forType((Type)type))).toArray(JavaType[]::new);
            return TypeFactoryUtils.instance().constructParametricType(rawClass, javaTypes);
        }
        return TypeFactoryUtils.javaType(rawClass);
    }

    public static <T> CollectionType collectionType(Class<T> type) {
        return TypeFactoryUtils.instance().constructCollectionType(Collection.class, type);
    }

    public static CollectionType collectionType(JavaType javaType) {
        return TypeFactoryUtils.instance().constructCollectionType(Collection.class, javaType);
    }

    public static <K, V> MapType mapType(Class<K> keyClass, Class<V> valueClass) {
        return TypeFactoryUtils.instance().constructMapType(Map.class, keyClass, valueClass);
    }

    public static MapType mapType(JavaType kType, JavaType vType) {
        return TypeFactoryUtils.instance().constructMapType(Map.class, kType, vType);
    }

    private TypeFactoryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

