/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.spring;

import com.livk.commons.util.ClassUtils;
import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class TraceEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String PROPERTY_SOURCE_NAME = "traceProperties";
    private static final String PROBABILITY_KEY = "management.tracing.sampling.probability";
    private static final String LEVEL_KEY = "logging.pattern.level";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (application.getWebApplicationType() == WebApplicationType.SERVLET && this.isPresent() && ((Boolean)environment.getProperty("management.tracing.enabled", Boolean.class, (Object)true)).booleanValue()) {
            MutablePropertySources propertySources;
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (!environment.containsProperty(PROBABILITY_KEY)) {
                map.put(PROBABILITY_KEY, 1.0);
            }
            if (!environment.containsProperty(LEVEL_KEY)) {
                if (StringUtils.hasText((String)environment.getProperty("spring.application.name"))) {
                    map.put(LEVEL_KEY, "%5p [${spring.application.name:},%X{traceId:-},%X{spanId:-}]");
                } else {
                    map.put(LEVEL_KEY, "%5p [%X{traceId:-},%X{spanId:-}]");
                }
            }
            if (!(propertySources = environment.getPropertySources()).contains(PROPERTY_SOURCE_NAME) && !map.isEmpty()) {
                MapPropertySource target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
                propertySources.addLast((PropertySource)target);
            }
        }
    }

    private boolean isPresent() {
        return ClassUtils.isPresent("org.springframework.boot.actuate.autoconfigure.tracing.OpenTelemetryAutoConfiguration") && ClassUtils.isPresent("io.micrometer.tracing.Tracer") && ClassUtils.isPresent("io.micrometer.tracing.otel.bridge.OtelTracer");
    }
}

