/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.spring.context;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.context.annotation.ImportCandidates;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractImportSelector<A extends Annotation>
implements DeferredImportSelector,
Ordered,
EnvironmentAware,
BeanClassLoaderAware {
    protected final Class<A> annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractImportSelector.class);
    protected Environment environment;
    protected ClassLoader classLoader;

    @NonNull
    public String[] selectImports(@Nullable AnnotationMetadata importingClassMetadata) {
        if (!this.isEnabled()) {
            return new String[0];
        }
        Assert.notNull(this.annotationClass, (String)"annotation Class not be null");
        List names = ImportCandidates.load(this.annotationClass, (ClassLoader)this.classLoader).getCandidates();
        return StringUtils.toStringArray((Collection)names);
    }

    protected boolean isEnabled() {
        return true;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void setBeanClassLoader(@NonNull ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

