/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.spring.context;

import com.livk.commons.util.ObjectUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResourceAccessException;

public class AnnotationMetadataResolver {
    private final ResourceLoader resourceLoader;
    private final ResourcePatternResolver resolver;
    private final MetadataReaderFactory metadataReaderFactory;

    public AnnotationMetadataResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public AnnotationMetadataResolver() {
        this((ResourceLoader)new DefaultResourceLoader());
    }

    public Set<Class<?>> find(Class<? extends Annotation> annotationType, String ... packages) {
        AnnotationTypeFilter typeFilter = new AnnotationTypeFilter(annotationType);
        return this.find((TypeFilter)typeFilter, packages);
    }

    public Set<Class<?>> find(TypeFilter typeFilter, String ... packages) {
        Function<MetadataReader, Class> function = metadataReader -> {
            String className = metadataReader.getClassMetadata().getClassName();
            return ClassUtils.resolveClassName((String)className, (ClassLoader)this.resourceLoader.getClassLoader());
        };
        return this.find(typeFilter, function, packages);
    }

    public Set<Class<?>> find(Class<? extends Annotation> annotationType, BeanFactory beanFactory) {
        return this.find(annotationType, StringUtils.toStringArray((Collection)AutoConfigurationPackages.get((BeanFactory)beanFactory)));
    }

    private <E> Set<E> find(TypeFilter typeFilter, Function<MetadataReader, E> function, String ... packages) {
        HashSet<E> result = new HashSet<E>();
        if (ObjectUtils.isEmpty((Object[])packages)) {
            return result;
        }
        for (String packageStr : packages) {
            packageStr = ClassUtils.convertClassNameToResourcePath((String)packageStr);
            try {
                Resource[] resources;
                for (Resource resource : resources = this.resolver.getResources("classpath*:" + packageStr + "/**/*.class")) {
                    MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                    if (!typeFilter.match(metadataReader, this.metadataReaderFactory)) continue;
                    result.add(function.apply(metadataReader));
                }
            }
            catch (IOException e) {
                throw new ResourceAccessException("Failed to read metadata", e);
            }
        }
        return result;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

