/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.spring.context;

import com.livk.commons.spring.context.AutoImport;
import com.livk.commons.spring.context.SpringAbstractImportSelector;
import com.livk.commons.util.ClassUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.boot.context.annotation.ImportCandidates;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

class AutoImportSelector
extends SpringAbstractImportSelector<AutoImport> {
    AutoImportSelector() {
    }

    @Override
    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        HashSet names = new HashSet();
        if (this.annotationClass != null) {
            for (String annotationType : metadata.getAnnotationTypes()) {
                Class type = ClassUtils.resolveClassName((String)annotationType, (ClassLoader)this.getBeanClassLoader());
                if (!type.isAnnotation() || !type.isAnnotationPresent(this.annotationClass)) continue;
                names.addAll(ImportCandidates.load((Class)type, (ClassLoader)this.getBeanClassLoader()).getCandidates());
            }
        }
        return new ArrayList<String>(names);
    }
}

