/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.spring.context;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigurationImportSelector;
import org.springframework.boot.context.annotation.ImportCandidates;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class SpringAbstractImportSelector<A extends Annotation>
extends AutoConfigurationImportSelector
implements DeferredImportSelector {
    protected final Class<A> annotationClass = GenericTypeResolver.resolveTypeArgument(((Object)((Object)this)).getClass(), SpringAbstractImportSelector.class);

    protected SpringAbstractImportSelector() {
    }

    protected Class<?> getAnnotationClass() {
        return this.annotationClass;
    }

    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        Assert.notNull(this.annotationClass, (String)"annotation Class not be null");
        List configurations = ImportCandidates.load(this.annotationClass, (ClassLoader)this.getBeanClassLoader()).getCandidates();
        Assert.notEmpty((Collection)configurations, (String)("No auto configuration classes found in META-INF/spring/" + this.annotationClass.getName() + ".imports. If you are using a custom packaging, make sure that file is correct."));
        return configurations;
    }

    protected List<String> getExcludeAutoConfigurationsProperty() {
        return Collections.emptyList();
    }

    protected Set<String> getExclusions(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        return Collections.emptySet();
    }
}

