/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.spring.context;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.Order;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Order(value=-2147483648)
@Component(value="com.livk.commons.spring.context.SpringContextHolder")
public class SpringContextHolder
implements BeanFactoryAware,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SpringContextHolder.class);
    public static final String BEAN_NAME = "com.livk.commons.spring.context.SpringContextHolder";
    private static volatile ApplicationContext applicationContext = null;
    private static volatile BeanFactory beanFactory = null;

    public static void publishEvent(ApplicationEvent event) {
        applicationContext.publishEvent(event);
    }

    public static <T> T getBean(String name) {
        return (T)SpringContextHolder.getBeanFactory().getBean(name);
    }

    public static <T> T getBean(Class<T> typeClass) {
        return (T)SpringContextHolder.getBeanFactory().getBean(typeClass);
    }

    public static <T> T getBean(String name, Class<T> typeClass) {
        return (T)SpringContextHolder.getBeanFactory().getBean(name, typeClass);
    }

    public static <T> ObjectProvider<T> getBeanProvider(Class<T> typeClass) {
        return SpringContextHolder.getBeanFactory().getBeanProvider(typeClass);
    }

    public static <T> ObjectProvider<T> getBeanProvider(ResolvableType resolvableType) {
        return SpringContextHolder.getBeanFactory().getBeanProvider(resolvableType);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> typeClass) {
        return SpringContextHolder.getBeanFactory().getBeansOfType(typeClass);
    }

    public static String getProperty(String key) {
        return SpringContextHolder.getProperty(key, String.class);
    }

    public static <T> T getProperty(String key, Class<T> requiredType) {
        return (T)applicationContext.getEnvironment().getProperty(key, requiredType);
    }

    public static <T> T getProperty(String key, Class<T> requiredType, T defaultValue) {
        return (T)applicationContext.getEnvironment().getProperty(key, requiredType, defaultValue);
    }

    public static String resolvePlaceholders(String text) {
        return applicationContext.getEnvironment().resolvePlaceholders(text);
    }

    public static <T> void registerBean(T bean, String beanName) {
        ResolvableType resolvableType = ResolvableType.forInstance(bean);
        BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((ResolvableType)resolvableType, () -> bean);
        SpringContextHolder.registerBean((BeanDefinition)definitionBuilder.getBeanDefinition(), beanName);
    }

    public static void registerBean(BeanDefinition beanDefinition, String beanName) {
        BeanFactory beanFactory = SpringContextHolder.beanFactory;
        if (beanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory defaultBeanFactory = (DefaultListableBeanFactory)beanFactory;
            SpringContextHolder.registerBean((BeanDefinitionRegistry)defaultBeanFactory, beanDefinition, beanName);
        } else {
            beanFactory = applicationContext;
            if (beanFactory instanceof GenericApplicationContext) {
                GenericApplicationContext context = (GenericApplicationContext)beanFactory;
                SpringContextHolder.registerBean((BeanDefinitionRegistry)context, beanDefinition, beanName);
            } else {
                log.error("bean register fail name: {} instantClass: {}", (Object)beanName, (Object)beanDefinition.getResolvableType());
            }
        }
    }

    private static void registerBean(BeanDefinitionRegistry registry, BeanDefinition beanDefinition, String beanName) {
        beanName = StringUtils.hasText((String)beanName) ? beanName : BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
        registry.registerBeanDefinition(beanName, beanDefinition);
    }

    private static ListableBeanFactory getBeanFactory() {
        ApplicationContext applicationContext;
        BeanFactory beanFactory = SpringContextHolder.beanFactory;
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)beanFactory;
            applicationContext = listableBeanFactory;
        } else {
            applicationContext = SpringContextHolder.applicationContext;
        }
        return applicationContext;
    }

    public synchronized void setBeanFactory(@Nullable BeanFactory beanFactory) throws BeansException {
        SpringContextHolder.beanFactory = beanFactory;
    }

    public synchronized void setApplicationContext(@Nullable ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public synchronized void destroy() {
        applicationContext = null;
        beanFactory = null;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

