/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.spring.env;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;

public class SpringEnvBinder {
    private final Environment environment;
    private final ConfigurableConversionService conversionService;

    public SpringEnvBinder(Environment environment, ConfigurableConversionService conversionService) {
        this.environment = environment;
        this.conversionService = conversionService;
    }

    public SpringEnvBinder(Environment environment) {
        this(environment, (ConfigurableConversionService)new DefaultConversionService());
    }

    public SpringEnvBinder addConverter(Converter<?, ?> converter) {
        this.conversionService.addConverter(converter);
        return this;
    }

    public Binder binder() {
        Iterable sources = ConfigurationPropertySources.get((Environment)this.environment);
        PropertySourcesPlaceholdersResolver placeholdersResolver = new PropertySourcesPlaceholdersResolver(this.environment);
        return new Binder(sources, (PlaceholdersResolver)placeholdersResolver, (ConversionService)this.conversionService);
    }

    public <T> BindResult<T> of(String name, ResolvableType type) {
        return this.bind(name, Bindable.of((ResolvableType)type));
    }

    public <E> BindResult<List<E>> listOf(String name, Class<E> type) {
        return this.bind(name, Bindable.listOf(type));
    }

    public <E> BindResult<Set<E>> setOf(String name, Class<E> type) {
        return this.bind(name, Bindable.setOf(type));
    }

    public <K, V> BindResult<Map<K, V>> mapOf(String name, Class<K> kType, Class<V> vType) {
        return this.bind(name, Bindable.mapOf(kType, vType));
    }

    public BindResult<Properties> propertiesOf(String name) {
        return this.bind(name, Properties.class);
    }

    public <T> BindResult<T> bind(String name, Bindable<T> bindable) {
        return this.binder().bind(name, bindable);
    }

    public <T> BindResult<T> bind(String name, Class<T> type) {
        return this.binder().bind(name, type);
    }
}

