/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;

public final class AnnotationUtils
extends org.springframework.core.annotation.AnnotationUtils {
    public static <A extends Annotation> A getAnnotationElement(MethodParameter methodParameter, Class<A> annotationClass) {
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)methodParameter.getAnnotatedElement(), annotationClass);
        if (annotation == null) {
            Class containingClass = methodParameter.getContainingClass();
            annotation = AnnotationUtils.getAnnotation((AnnotatedElement)containingClass, annotationClass);
        }
        return (A)annotation;
    }

    public static <A extends Annotation> A getAnnotationElement(Method method, Class<A> annotationClass) {
        Annotation annotation = AnnotationUtils.getAnnotation((Method)method, annotationClass);
        if (annotation == null) {
            annotation = AnnotationUtils.getAnnotation(method.getDeclaringClass(), annotationClass);
        }
        return (A)annotation;
    }

    public static <A extends Annotation> boolean hasAnnotationElement(MethodParameter methodParameter, Class<A> annotationClass) {
        Class containingClass = methodParameter.getContainingClass();
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)containingClass, annotationClass) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)methodParameter.getAnnotatedElement(), annotationClass);
    }

    public static <A extends Annotation> boolean hasAnnotationElement(Method method, Class<A> annotationClass) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, annotationClass) || AnnotatedElementUtils.hasAnnotation(method.getDeclaringClass(), annotationClass);
    }

    public static AnnotationAttributes attributesFor(AnnotatedTypeMetadata metadata, String annotationClassName) {
        return AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(annotationClassName));
    }

    public static <A extends Annotation> AnnotationAttributes attributesFor(AnnotatedTypeMetadata metadata, Class<A> annotationClass) {
        return AnnotationUtils.attributesFor(metadata, annotationClass.getName());
    }

    public static <E extends Enum<?>> E[] getValue(AnnotationAttributes attributes, String key) {
        Object value = attributes.get((Object)key);
        if (!(value instanceof Enum[]) && Enum[].class.getComponentType().isInstance(value)) {
            Object array = Array.newInstance(Enum[].class.getComponentType(), 1);
            Array.set(array, 0, value);
            value = array;
        }
        return (Enum[])value;
    }

    private AnnotationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

