/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.livk.commons.util.EnumerationSpliterator;
import com.livk.commons.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class BaseStreamUtils {
    @SafeVarargs
    public static <K, V> Map<K, List<V>> concat(Map<K, V> ... maps) {
        if (ObjectUtils.isEmpty((Object[])maps)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(maps).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    @SafeVarargs
    public static <T> Stream<T> concat(T[] ... ts) {
        if (ObjectUtils.isEmpty(ts)) {
            return Stream.empty();
        }
        return Arrays.stream(ts).filter(Objects::nonNull).flatMap(Arrays::stream);
    }

    public static String[] concat(boolean distinct, String[] ... strArr) {
        Stream<String> concat = BaseStreamUtils.concat(strArr);
        if (distinct) {
            concat = concat.distinct();
        }
        return (String[])concat.toArray(String[]::new);
    }

    public static String[] concatDistinct(String[] ... strArr) {
        return BaseStreamUtils.concat(true, strArr);
    }

    public static int[] concat(int[] ... intArray) {
        if (ObjectUtils.isEmpty((Object[])intArray)) {
            return IntStream.empty().toArray();
        }
        return Arrays.stream(intArray).filter(Objects::nonNull).flatMapToInt(Arrays::stream).toArray();
    }

    public static long[] concat(long[] ... longArray) {
        if (ObjectUtils.isEmpty((Object[])longArray)) {
            return LongStream.empty().toArray();
        }
        return Arrays.stream(longArray).filter(Objects::nonNull).flatMapToLong(Arrays::stream).toArray();
    }

    public static double[] concat(double[] ... doubleArray) {
        if (ObjectUtils.isEmpty((Object[])doubleArray)) {
            return DoubleStream.empty().toArray();
        }
        return Arrays.stream(doubleArray).filter(Objects::nonNull).flatMapToDouble(Arrays::stream).toArray();
    }

    @SafeVarargs
    public static <T, R> Stream<R> zip(Function<Stream<T>, Stream<R>> combinator, Stream<T> ... streams) {
        return ObjectUtils.isEmpty((Object[])streams) ? Stream.empty() : Stream.of(streams).flatMap(combinator);
    }

    public static <T> Predicate<T> distinct(Function<? super T, ?> function) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(function.apply(t), Boolean.TRUE) == null;
    }

    public static <T> Stream<T> convert(Enumeration<T> enumeration) {
        return StreamSupport.stream(EnumerationSpliterator.spliteratorUnknownSize(enumeration), false);
    }

    public static <T, R> Function<T, R> mapWithIndex(int initValue, BiFunction<T, Integer, R> biFunction) {
        AtomicInteger atomicInteger = new AtomicInteger(initValue);
        return t -> biFunction.apply(t, atomicInteger.getAndIncrement());
    }

    public static <T> Consumer<T> forEachWithIndex(int initValue, BiConsumer<T, Integer> biConsumer) {
        AtomicInteger atomicInteger = new AtomicInteger(initValue);
        return t -> biConsumer.accept(t, atomicInteger.getAndIncrement());
    }

    private BaseStreamUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

