/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.livk.commons.util.ReflectionUtils;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.beans.BeanWrapperImpl;

public final class BeanUtils
extends org.springframework.beans.BeanUtils {
    public static <T> T copy(Object source, Class<T> targetClass) {
        return (T)BeanUtils.copy(source, () -> BeanUtils.instantiateClass((Class)targetClass));
    }

    public static <T> T copy(Object source, Supplier<T> supplier) {
        if (supplier == null) {
            return null;
        }
        T t = supplier.get();
        if (source != null) {
            BeanUtils.copyProperties((Object)source, t);
        }
        return t;
    }

    public static <T> List<T> copyList(Collection<?> sourceList, Class<T> targetClass) {
        return sourceList.stream().map(source -> BeanUtils.copy(source, targetClass)).toList();
    }

    public static boolean isFieldNull(Object source) {
        if (source == null) {
            return true;
        }
        return Stream.of(source.getClass().getDeclaredFields()).anyMatch(field -> ReflectionUtils.getDeclaredFieldValue(field, source) == null);
    }

    public static Map<String, Object> convert(Object source) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(source);
        PropertyDescriptor[] descriptors = beanWrapper.getPropertyDescriptors();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PropertyDescriptor descriptor : descriptors) {
            if ("class".equals(descriptor.getName())) continue;
            Object propertyValue = beanWrapper.getPropertyValue(descriptor.getName());
            map.put(descriptor.getName(), propertyValue);
        }
        return map;
    }

    private BeanUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

