/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class ClassUtils
extends org.springframework.util.ClassUtils {
    public static <T> Class<T> toClass(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ClassUtils.toClass(parameterizedType.getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            String className = typeVariable.getGenericDeclaration().toString();
            return ClassUtils.toClass(ClassUtils.resolveClassName(className));
        }
        return (Class)type;
    }

    public static Class<?> resolveClassName(String className) {
        return ClassUtils.resolveClassName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
    }

    public static boolean isPresent(String className) {
        return ClassUtils.isPresent((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
    }

    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

