/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    public static final String YMD = "yyyy-MM-dd";
    public static final String HMS = "HH:mm:ss";
    public static final String YMD_HMS = "yyyy-MM-dd HH:mm:ss";

    public static Long timestamp(LocalDateTime localDateTime) {
        return DateUtils.timestamp(localDateTime, ZoneId.systemDefault());
    }

    public static Long timestamp(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toEpochSecond();
    }

    public static LocalDateTime localDateTime(Long timeStamp) {
        return DateUtils.localDateTime(timeStamp, ZoneId.systemDefault());
    }

    public static LocalDateTime localDateTime(Long timeStamp, ZoneId zoneId) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(timeStamp), zoneId);
    }

    public static Date date(LocalDateTime localDateTime) {
        return DateUtils.date(localDateTime, ZoneId.systemDefault());
    }

    public static Date date(LocalDateTime localDateTime, ZoneId zoneId) {
        return Date.from(localDateTime.atZone(zoneId).toInstant());
    }

    public static Date date(LocalDate localDate) {
        return DateUtils.date(localDate, ZoneId.systemDefault());
    }

    public static Date date(LocalDate localDate, ZoneId zoneId) {
        return DateUtils.date(localDate.atTime(LocalTime.now(zoneId)));
    }

    public static LocalDateTime localDateTime(Date date) {
        return DateUtils.localDateTime(date, ZoneId.systemDefault());
    }

    public static LocalDateTime localDateTime(Date date, ZoneId zoneId) {
        return LocalDateTime.ofInstant(date.toInstant(), zoneId);
    }

    public static String format(LocalDateTime localDateTime, String patten) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(patten);
        return DateUtils.format(localDateTime, formatter);
    }

    public static String format(LocalDateTime localDateTime, String patten, ZoneId zoneId) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(patten).withZone(zoneId);
        return DateUtils.format(localDateTime, formatter);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter formatter) {
        return formatter.format(localDateTime);
    }

    public static LocalDateTime parse(String localDateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(localDateTime, dateTimeFormatter);
    }

    public static LocalDateTime parse(String localDateTime, String pattern, ZoneId zoneId) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern).withZone(zoneId);
        return LocalDateTime.parse(localDateTime, dateTimeFormatter);
    }

    private DateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

