/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Iterator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class MultiValueMapSplitter {
    private static final String INVALID_ENTRY_MESSAGE = "Chunk [%s] is not a valid entry";
    private final Splitter outerSplitter;
    private final Splitter entrySplitter;

    private MultiValueMapSplitter(Splitter outerSplitter, Splitter entrySplitter) {
        this.outerSplitter = outerSplitter;
        this.entrySplitter = (Splitter)Preconditions.checkNotNull((Object)entrySplitter);
    }

    public static MultiValueMapSplitter of(Splitter outerSplitter, Splitter entrySplitter) {
        return new MultiValueMapSplitter(outerSplitter, entrySplitter);
    }

    public static MultiValueMapSplitter of(Splitter outerSplitter, String entrySplitter) {
        return new MultiValueMapSplitter(outerSplitter, Splitter.on((String)entrySplitter));
    }

    public static MultiValueMapSplitter of(String outerSplitter, String entrySplitter) {
        return new MultiValueMapSplitter(Splitter.on((String)outerSplitter), Splitter.on((String)entrySplitter));
    }

    public MultiValueMap<String, String> split(CharSequence sequence) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (String entry : this.outerSplitter.split(sequence)) {
            Iterator entryFields = this.entrySplitter.split((CharSequence)entry).iterator();
            Preconditions.checkArgument((boolean)entryFields.hasNext(), (String)INVALID_ENTRY_MESSAGE, (Object)entry);
            String key = (String)entryFields.next();
            Preconditions.checkArgument((boolean)entryFields.hasNext(), (String)INVALID_ENTRY_MESSAGE, (Object)entry);
            String value = (String)entryFields.next();
            map.add((Object)key, (Object)value);
            Preconditions.checkArgument((!entryFields.hasNext() ? 1 : 0) != 0, (String)INVALID_ENTRY_MESSAGE, (Object)entry);
        }
        return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)map);
    }
}

