/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.type.TypeBindings;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

@JsonSerialize(using=PairJsonSerializer.class)
@JsonDeserialize(using=PairJsonDeserializer.class)
public final class Pair<K, V>
implements Serializable,
Cloneable {
    public static final Pair<?, ?> EMPTY = Pair.of(null, null);
    private static final long serialVersionUID = -2303547536834226401L;
    private final K key;
    private final V value;

    public static <K, V> Pair<K, V> of(Map.Entry<K, V> entry) {
        return Pair.of(entry.getKey(), entry.getValue());
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public Map<K, V> toMap() {
        return Map.of(this.key, this.value);
    }

    public Map.Entry<K, V> toEntry() {
        return Map.entry(this.key, this.value);
    }

    public <S, U> Pair<S, U> map(Function<K, S> keyFunction, Function<V, U> valueFunction) {
        return Pair.of(keyFunction.apply(this.key), valueFunction.apply(this.value));
    }

    public <S> Pair<S, V> keyMap(Function<K, S> keyFunction) {
        return this.map(keyFunction, Function.identity());
    }

    public <U> Pair<K, U> valueMap(Function<V, U> valueFunction) {
        return this.map(Function.identity(), valueFunction);
    }

    public <S, U> Pair<S, U> flatMap(BiFunction<K, V, Pair<S, U>> biFunction) {
        return biFunction.apply(this.key, this.value);
    }

    public Pair<K, V> clone() {
        try {
            return (Pair)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "{" + String.valueOf(this.key) + ":" + String.valueOf(this.value) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        K this$key = this.key;
        K other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        V this$value = this.value;
        V other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        V $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    private Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    static class PairJsonDeserializer
    extends StdScalarDeserializer<Pair<Object, Object>>
    implements ContextualDeserializer {
        private KeyDeserializer keyDeserializer;
        private JavaType valueType;

        protected PairJsonDeserializer() {
            super(Pair.class);
        }

        public Pair<Object, Object> deserialize(JsonParser p, DeserializationContext context) throws IOException {
            p.nextToken();
            String name = p.currentName();
            JsonNode valueNode = context.readTree(p).get(name);
            ObjectMapper mapper = (ObjectMapper)p.getCodec();
            return Pair.of(this.keyDeserializer.deserializeKey(name, context), mapper.convertValue((Object)valueNode, this.valueType));
        }

        public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
            JavaType contextualType = context.getContextualType();
            TypeBindings bindings = contextualType.getBindings();
            JavaType keyType = bindings.getBoundType(0);
            this.valueType = bindings.getBoundType(1);
            this.keyDeserializer = context.findKeyDeserializer(keyType, property);
            return this;
        }
    }

    static class PairJsonSerializer
    extends StdScalarSerializer<Pair<Object, Object>>
    implements ContextualSerializer {
        private JsonSerializer<Object> keySerializer;

        protected PairJsonSerializer() {
            super(Pair.class, false);
        }

        public void serialize(Pair<Object, Object> pair, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject(pair);
            this.keySerializer.serialize(pair.key(), gen, provider);
            gen.writeObject(pair.value());
            gen.writeEndObject();
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            this.keySerializer = prov.findKeySerializer(Object.class, property);
            return this;
        }
    }
}

