/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.google.common.collect.Lists;
import com.livk.commons.util.ClassUtils;
import java.util.List;
import java.util.ServiceLoader;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;

public sealed interface ProviderLoader {
    public static final ProviderLoader JDK_SERVICE = new AbstractLoader.JdkServiceLoader();
    public static final ProviderLoader SPRING_FACTORY = new AbstractLoader.SpringFactoryLoader();

    default public <T> List<T> load(Class<T> type) {
        return this.load(type, ClassUtils.getDefaultClassLoader());
    }

    public <T> List<T> load(Class<T> var1, ClassLoader var2);

    default public <T> List<T> load(ResolvableType resolvableType) {
        Class type = ClassUtils.toClass(resolvableType.getType());
        return this.load(type);
    }

    default public <T> List<T> load(ResolvableType resolvableType, ClassLoader classLoader) {
        Class type = ClassUtils.toClass(resolvableType.getType());
        return this.load(type, classLoader);
    }

    public static abstract non-sealed class AbstractLoader
    implements ProviderLoader {

        private static final class SpringFactoryLoader
        extends AbstractLoader {
            private SpringFactoryLoader() {
            }

            @Override
            public <T> List<T> load(Class<T> type, ClassLoader classLoader) {
                return SpringFactoriesLoader.loadFactories(type, (ClassLoader)classLoader);
            }
        }

        private static final class JdkServiceLoader
        extends AbstractLoader {
            private JdkServiceLoader() {
            }

            @Override
            public final <T> List<T> load(Class<T> type) {
                return Lists.newArrayList(ServiceLoader.load(type));
            }

            @Override
            public <T> List<T> load(Class<T> type, ClassLoader classLoader) {
                return Lists.newArrayList(ServiceLoader.load(type, classLoader));
            }
        }
    }
}

