/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.livk.commons.util.BeanUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils
extends org.springframework.util.ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);

    public static void setFieldAndAccessible(Field field, Object parameter, Object value) {
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, (Object)parameter, (Object)value);
    }

    public static Set<Method> getReadMethods(Class<?> targetClass) {
        return Arrays.stream(BeanUtils.getPropertyDescriptors(targetClass)).map(PropertyDescriptor::getReadMethod).filter(method -> !method.getName().equals("getClass")).collect(Collectors.toSet());
    }

    public static Method getReadMethod(Class<?> targetClass, Field field) {
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), targetClass);
            return descriptor.getReadMethod();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b57\u6bb5get\u65b9\u6cd5\u5931\u8d25 message: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static Set<Method> getWriteMethods(Class<?> targetClass) {
        return Arrays.stream(BeanUtils.getPropertyDescriptors(targetClass)).map(PropertyDescriptor::getWriteMethod).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Method getWriteMethod(Class<?> targetClass, Field field) {
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), targetClass);
            return descriptor.getWriteMethod();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b57\u6bb5set\u65b9\u6cd5\u5931\u8d25 message: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static List<Field> getAllFields(Class<?> targetClass) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = targetClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    public static Object getDeclaredFieldValue(Field field, Object target) {
        field.setAccessible(true);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

