/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.TablesNamesFinder;

public final class SqlParserUtils {
    public static Set<String> parseTable(String sql) {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        TablesNamesFinder namesFinder = new TablesNamesFinder();
        return namesFinder.getTables(statement);
    }

    public static List<String> getParams(String sql) {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            Select select = (Select)statement;
            return select.getPlainSelect().getSelectItems().stream().map(Object::toString).toList();
        }
        if (statement instanceof Update) {
            Update update = (Update)statement;
            return update.getUpdateSets().stream().flatMap(updateSet -> updateSet.getColumns().stream()).map(Column::getColumnName).toList();
        }
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            return insert.getColumns().stream().map(Column::getColumnName).toList();
        }
        return Collections.emptyList();
    }

    public static String formatSql(String sql) {
        return CCJSqlParserUtil.parse((String)sql).toString();
    }

    private SqlParserUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

