/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TreeNode<I, T> {
    private static final Logger log = LoggerFactory.getLogger(TreeNode.class);
    private I id;
    private T node;
    private I pid;
    private List<TreeNode<I, T>> children;

    public static <I, T> TreeNode<I, T> createRoot(I id, T node) {
        return new TreeNode<Object, T>(id, node, null, new ArrayList<TreeNode<I, T>>());
    }

    public boolean addChild(TreeNode<I, T> treeNo) {
        if (this.findById(treeNo.id) != null) {
            log.info("\u51fa\u73b0\u76f8\u540c\u8282\u70b9 id:{}", treeNo.id);
            return false;
        }
        TreeNode<I, T> parent = this.findById(treeNo.pid);
        if (parent == null) {
            return false;
        }
        if (CollectionUtils.isEmpty(parent.children)) {
            parent.children = new ArrayList<TreeNode<I, T>>();
        }
        return parent.children.add(treeNo);
    }

    public void setChildren(List<TreeNode<I, T>> nodes) {
        List<TreeNode> treeNodeList = nodes.stream().filter(node -> this.id.equals(node.pid)).toList();
        if (!CollectionUtils.isEmpty(treeNodeList)) {
            this.children = new ArrayList<TreeNode<I, T>>();
            this.children.addAll(treeNodeList);
            this.children.forEach(child -> child.setChildren(nodes));
        }
    }

    public TreeNode<I, T> findById(I id) {
        if (this.id.equals(id)) {
            return this;
        }
        if (!CollectionUtils.isEmpty(this.children)) {
            for (TreeNode<I, T> child : this.children) {
                TreeNode<I, T> treeNo = child.findById(id);
                if (treeNo == null) continue;
                return treeNo;
            }
        }
        return null;
    }

    public I getId() {
        return this.id;
    }

    public T getNode() {
        return this.node;
    }

    public I getPid() {
        return this.pid;
    }

    public List<TreeNode<I, T>> getChildren() {
        return this.children;
    }

    public TreeNode<I, T> setId(I id) {
        this.id = id;
        return this;
    }

    public TreeNode<I, T> setNode(T node) {
        this.node = node;
        return this;
    }

    public TreeNode<I, T> setPid(I pid) {
        this.pid = pid;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeNode)) {
            return false;
        }
        TreeNode other = (TreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        I this$id = this.getId();
        I other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        T this$node = this.getNode();
        T other$node = other.getNode();
        if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
            return false;
        }
        I this$pid = this.getPid();
        I other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !this$pid.equals(other$pid)) {
            return false;
        }
        List<TreeNode<I, T>> this$children = this.getChildren();
        List<TreeNode<I, T>> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        I $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        T $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : $node.hashCode());
        I $pid = this.getPid();
        result = result * 59 + ($pid == null ? 43 : $pid.hashCode());
        List<TreeNode<I, T>> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "TreeNode(id=" + String.valueOf(this.getId()) + ", node=" + String.valueOf(this.getNode()) + ", pid=" + String.valueOf(this.getPid()) + ", children=" + String.valueOf(this.getChildren()) + ")";
    }

    public TreeNode() {
    }

    public TreeNode(I id, T node, I pid, List<TreeNode<I, T>> children) {
        this.id = id;
        this.node = node;
        this.pid = pid;
        this.children = children;
    }
}

