/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import com.google.common.collect.Lists;
import com.livk.commons.jackson.util.JsonMapperUtils;
import com.livk.commons.util.BaseStreamUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.ErrorResponseException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class WebUtils
extends org.springframework.web.util.WebUtils {
    private static final String UNKNOWN = "unknown";
    private static final String HTTP_IP_SPLIT = ",";

    private static ServletRequestAttributes servletRequestAttributes() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        Assert.notNull((Object)servletRequestAttributes, (String)"attributes not null!");
        return servletRequestAttributes;
    }

    public static HttpServletRequest request() {
        return WebUtils.servletRequestAttributes().getRequest();
    }

    public static HttpServletResponse response() {
        return WebUtils.servletRequestAttributes().getResponse();
    }

    public static HttpHeaders headers(HttpServletRequest request) {
        LinkedCaseInsensitiveMap insensitiveMap = new LinkedCaseInsensitiveMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headers = request.getHeaders(headerName);
            insensitiveMap.put(headerName, Collections.list(headers));
        }
        return new HttpHeaders(CollectionUtils.toMultiValueMap((Map)insensitiveMap));
    }

    public static Map<String, Object> attributes(HttpServletRequest request) {
        return BaseStreamUtils.convert(request.getAttributeNames()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((HttpServletRequest)request).getAttribute(arg_0)));
    }

    public static Map<String, String> paramMap(HttpServletRequest request, CharSequence delimiter) {
        return request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.join(delimiter, (CharSequence[])entry.getValue())));
    }

    public static MultiValueMap<String, String> params(HttpServletRequest request) {
        Map<String, List> map = request.getParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Lists.newArrayList((Object[])((String[])entry.getValue()))));
        return new LinkedMultiValueMap(map);
    }

    public static String realIp(HttpServletRequest request) {
        String ip;
        String[] ipHeaders = new String[]{"X-Real-IP", "X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP"};
        Optional<String> optional = Optional.empty();
        for (String header : ipHeaders) {
            String headerIp = request.getHeader(header);
            if (headerIp == null || headerIp.isBlank() || UNKNOWN.equalsIgnoreCase(headerIp)) continue;
            optional = Optional.of(headerIp);
            break;
        }
        return (ip = optional.orElse(request.getRemoteAddr())) != null && ip.contains(HTTP_IP_SPLIT) ? ip.split(HTTP_IP_SPLIT)[0] : ip;
    }

    public static void outJson(HttpServletResponse response, Object data) {
        WebUtils.out(response, JsonMapperUtils.writeValueAsString(data), "application/json");
    }

    public static void out(HttpServletResponse response, String message, String contentType) {
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        try (PrintWriter out = response.getWriter();){
            out.print(message);
            out.flush();
        }
        catch (IOException exception) {
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)exception);
        }
    }

    private WebUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

