/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.yaml.snakeyaml.Yaml;

public final class YamlUtils {
    public static String toYml(Map<?, ?> map) {
        if (CollectionUtils.isEmpty(map)) {
            return "";
        }
        Map<String, Object> yamlMap = YamlUtils.convertMapToYaml(map);
        return new Yaml().dumpAsMap(yamlMap);
    }

    public static Map<String, Object> convertMapToYaml(Map<?, ?> map) {
        LinkedHashMap<String, Object> yamlMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : YamlUtils.envTransform(map).entrySet()) {
            String[] keys = entry.getKey().split("\\.");
            Map<String, Object> tempMap = yamlMap;
            for (int i = 0; i < keys.length - 1; ++i) {
                String key = keys[i];
                if (key.contains("[")) {
                    int index = YamlUtils.index(key);
                    key = key.substring(0, key.indexOf(91));
                    tempMap.putIfAbsent(key, new ArrayList());
                    List list = (List)tempMap.get(key);
                    while (list.size() <= index) {
                        list.add(new LinkedHashMap());
                    }
                    tempMap = (Map)list.get(index);
                    continue;
                }
                tempMap.putIfAbsent(key, new LinkedHashMap());
                tempMap = (Map)tempMap.get(key);
            }
            String lastKey = keys[keys.length - 1];
            if (lastKey.contains("[")) {
                int index = YamlUtils.index(lastKey);
                lastKey = lastKey.substring(0, lastKey.indexOf(91));
                tempMap.putIfAbsent(lastKey, new ArrayList());
                List list = (List)tempMap.get(lastKey);
                while (list.size() <= index) {
                    list.add(null);
                }
                list.set(index, entry.getValue());
                continue;
            }
            tempMap.put(keys[keys.length - 1], entry.getValue());
        }
        return yamlMap;
    }

    private static Map<String, Object> envTransform(Map<?, ?> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String[] keys;
            StringBuilder builder = new StringBuilder();
            for (String key : keys = entry.getKey().toString().split("\\.")) {
                if (StringUtils.isNumeric((CharSequence)key)) {
                    builder.append("[").append(key).append("]");
                    continue;
                }
                builder.append(".").append(key);
            }
            builder.deleteCharAt(0);
            result.put(builder.toString(), entry.getValue());
        }
        return result;
    }

    private static Integer index(String key) {
        return Integer.parseInt(key.substring(key.indexOf(91) + 1, key.indexOf(93)));
    }

    public static Properties convertYamlToMap(Map<String, Object> source) {
        Properties result = new Properties();
        YamlUtils.buildFlattenedMap(result, source, null);
        return result;
    }

    private static void buildFlattenedMap(Properties result, Map<String, Object> source, @Nullable String path) {
        source.forEach((key, value) -> {
            if (org.springframework.util.StringUtils.hasText((String)path)) {
                key = ((String)key).startsWith("[") ? path + (String)key : path + "." + (String)key;
            }
            Object selector0$temp = value;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Map.class, Collection.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    String s = (String)selector0$temp;
                    result.put(key, s);
                    break;
                }
                case 1: {
                    Map map = (Map)selector0$temp;
                    YamlUtils.buildFlattenedMap(result, map, (String)key);
                    break;
                }
                case 2: {
                    Collection collection = (Collection)selector0$temp;
                    if (collection.isEmpty()) {
                        result.put(key, "");
                        break;
                    }
                    int count = 0;
                    for (Object object : collection) {
                        YamlUtils.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), (String)key);
                    }
                    break;
                }
                default: {
                    result.put(key, value != null ? value : "");
                }
            }
        });
    }

    private YamlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

