/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.web;

import com.livk.commons.util.BaseStreamUtils;
import com.livk.commons.util.ObjectUtils;
import com.livk.commons.util.WebUtils;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private final HttpHeaders headers = new HttpHeaders();
    private final Map<String, String[]> parameter = new LinkedHashMap<String, String[]>(16);
    private byte[] body;
    private boolean bodyReviseStatus = false;

    public RequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.headers.putAll((Map)WebUtils.headers(request));
        this.parameter.putAll(request.getParameterMap());
        this.body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public void setBody(byte[] body) {
        this.bodyReviseStatus = true;
        this.body = body;
    }

    public void addHeader(String name, String value) {
        this.headers.add(name, value);
    }

    public void putParameter(String name, String[] values) {
        this.parameter.merge(name, values, (xva$0, xva$1) -> BaseStreamUtils.concatDistinct(xva$0, xva$1));
    }

    public void putParameter(String name, String value) {
        this.putParameter(name, new String[]{value});
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ByteArrayServletInputStream(this.body);
    }

    public BufferedReader getReader() {
        return new BufferedReader(new ByteArrayReader(this.body));
    }

    public int getContentLength() {
        return this.bodyReviseStatus ? this.body.length : super.getContentLength();
    }

    public long getContentLengthLong() {
        return this.bodyReviseStatus ? (long)this.body.length : super.getContentLengthLong();
    }

    public String getContentType() {
        return this.bodyReviseStatus ? "application/json" : super.getContentType();
    }

    public String getParameter(String name) {
        Object[] values = this.getParameterValues(name);
        return ObjectUtils.isEmpty((Object[])values) ? null : values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameter;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameter.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameter.get(name);
    }

    public String getHeader(String name) {
        if ("Content-Type".equalsIgnoreCase(name) && this.bodyReviseStatus) {
            return this.getContentType();
        }
        return this.headers.getFirst(name);
    }

    public Enumeration<String> getHeaderNames() {
        Set headerNames = this.headers.keySet();
        if (this.bodyReviseStatus) {
            headerNames.add("Content-Type");
        }
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        List list;
        HashSet<String> headerValues = new HashSet<String>();
        if ("Content-Type".equalsIgnoreCase(name) && this.bodyReviseStatus) {
            headerValues.add(this.getContentType());
        }
        if (!CollectionUtils.isEmpty((Collection)(list = this.headers.get((Object)name)))) {
            headerValues.addAll(list);
        }
        return Collections.enumeration(headerValues);
    }

    private static class ByteArrayServletInputStream
    extends ServletInputStream {
        private final InputStream in;

        public ByteArrayServletInputStream(byte[] body) {
            this.in = new ByteArrayInputStream(body);
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener listener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            return this.in.read();
        }
    }

    private static class ByteArrayReader
    extends InputStreamReader {
        public ByteArrayReader(byte[] bytes) {
            super(new ByteArrayInputStream(bytes));
        }
    }
}

