/*
 * Decompiled with CFR 0.152.
 */
package com.livk.commons.web;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.springframework.util.StreamUtils;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() {
        return new WrapperOutputStream(super.getResponse(), this.buffer);
    }

    public PrintWriter getWriter() {
        return new PrintWriter(new OutputStreamWriter(this.buffer));
    }

    public void reset() {
        this.buffer.reset();
    }

    public byte[] getResponseData() {
        return this.buffer.toByteArray();
    }

    public void setResponseData(byte[] bytes) throws IOException {
        this.buffer.reset();
        StreamUtils.copy((byte[])bytes, (OutputStream)this.buffer);
    }

    private static class WrapperOutputStream
    extends ServletOutputStream {
        private final ServletResponse response;
        private final ByteArrayOutputStream outputStream;

        public void write(int b) {
            this.outputStream.write(b);
        }

        public void flush() throws IOException {
            if (!this.response.isCommitted()) {
                byte[] body = this.outputStream.toByteArray();
                ServletOutputStream stream = this.response.getOutputStream();
                stream.write(body);
                stream.flush();
            }
        }

        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException("setWriteListener");
        }

        public boolean isReady() {
            return false;
        }

        public String toString() {
            return this.outputStream.toString();
        }

        public WrapperOutputStream(ServletResponse response, ByteArrayOutputStream outputStream) {
            this.response = response;
            this.outputStream = outputStream;
        }
    }
}

