/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.disruptor;

import com.livk.commons.util.AnnotationUtils;
import com.livk.context.disruptor.annotation.DisruptorEvent;
import com.livk.context.disruptor.factory.DisruptorFactoryBean;
import com.livk.context.disruptor.support.SpringDisruptor;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class ClassPathDisruptorScanner
extends ClassPathBeanDefinitionScanner {
    private final BeanNameGenerator beanNameGenerator;

    public ClassPathDisruptorScanner(BeanDefinitionRegistry registry) {
        this(registry, (BeanNameGenerator)new DefaultBeanNameGenerator());
    }

    public ClassPathDisruptorScanner(BeanDefinitionRegistry registry, BeanNameGenerator beanNameGenerator) {
        super(registry, false);
        this.beanNameGenerator = beanNameGenerator;
    }

    public void registerFilters(Class<? extends Annotation> annotationType) {
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation();
    }

    @NonNull
    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        LinkedHashSet<BeanDefinitionHolder> definitionHolders = new LinkedHashSet<BeanDefinitionHolder>();
        BeanDefinitionRegistry registry = super.getRegistry();
        Assert.notNull((Object)registry, (String)"registry not be null");
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        for (String basePackage : basePackages) {
            Set candidateComponents = this.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof ScannedGenericBeanDefinition)) continue;
                ScannedGenericBeanDefinition scannedGenericBeanDefinition = (ScannedGenericBeanDefinition)candidateComponent;
                AnnotationMetadata metadata = scannedGenericBeanDefinition.getMetadata();
                AnnotationAttributes attributes = AnnotationUtils.attributesFor((AnnotatedTypeMetadata)metadata, DisruptorEvent.class);
                String beanClassName = candidateComponent.getBeanClassName();
                Assert.notNull((Object)beanClassName, (String)"beanClassName not be null");
                Class type = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)super.getResourceLoader().getClassLoader());
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DisruptorFactoryBean.class);
                builder.addPropertyValue("attributes", (Object)attributes);
                builder.addPropertyValue("type", (Object)type);
                builder.setAutowireMode(2);
                AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
                String name = attributes.getString("value");
                String beanName = StringUtils.hasText((String)name) ? name : this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry);
                if (!this.checkCandidate(beanName, (BeanDefinition)beanDefinition)) continue;
                ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SpringDisruptor.class, (Class[])new Class[]{type});
                beanDefinition.setAttribute("factoryBeanObjectType", (Object)resolvableType);
                BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName);
                definitionHolders.add(holder);
                this.registerBeanDefinition(holder, registry);
            }
        }
        return definitionHolders;
    }
}

