/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.disruptor;

import com.livk.context.disruptor.support.DisruptorEventWrapper;
import com.livk.context.disruptor.support.SpringDisruptor;
import com.lmax.disruptor.RingBuffer;
import java.util.Arrays;
import java.util.List;

public class DisruptorEventProducer<T> {
    private final RingBuffer<DisruptorEventWrapper<T>> ringBuffer;

    public DisruptorEventProducer(SpringDisruptor<T> disruptor) {
        this.ringBuffer = disruptor.getRingBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(T data) {
        long sequence = this.ringBuffer.next();
        try {
            DisruptorEventWrapper event = (DisruptorEventWrapper)this.ringBuffer.get(sequence);
            event.wrap(data);
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendBatch(List<T> dataList) {
        int n = dataList.size();
        long hi = this.ringBuffer.next(n);
        long lo = hi - (long)(n - 1);
        try {
            for (int i = 0; i < dataList.size(); ++i) {
                ((DisruptorEventWrapper)this.ringBuffer.get((long)i + lo)).wrap(dataList.get(i));
            }
        }
        finally {
            this.ringBuffer.publish(lo, hi);
        }
    }

    @SafeVarargs
    public final void sendBatch(T ... dataArray) {
        this.sendBatch(Arrays.asList(dataArray));
    }
}

