/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.disruptor;

import com.livk.commons.util.AnnotationUtils;
import com.livk.commons.util.ObjectUtils;
import com.livk.context.disruptor.ClassPathDisruptorScanner;
import com.livk.context.disruptor.EnableDisruptor;
import com.livk.context.disruptor.annotation.DisruptorEvent;
import com.livk.context.disruptor.exception.DisruptorRegistrarException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class DisruptorRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(DisruptorRegistrar.class);

    DisruptorRegistrar() {
    }

    public void registerBeanDefinitions(@NonNull AnnotationMetadata importingClassMetadata, @NonNull BeanDefinitionRegistry registry, @NonNull BeanNameGenerator beanNameGenerator) {
        Object[] basePackages = this.getBasePackages(importingClassMetadata);
        if (ObjectUtils.isEmpty((Object[])basePackages)) {
            throw new DisruptorRegistrarException(EnableDisruptor.class.getName() + " required basePackages or basePackageClasses");
        }
        ClassPathDisruptorScanner scanner = new ClassPathDisruptorScanner(registry, beanNameGenerator);
        scanner.registerFilters(DisruptorEvent.class);
        scanner.scan((String[])basePackages);
    }

    private String[] getBasePackages(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationUtils.attributesFor((AnnotatedTypeMetadata)metadata, EnableDisruptor.class);
        String[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            packagesToScan.add(ClassUtils.getPackageName((String)metadata.getClassName()));
        }
        return StringUtils.toStringArray(packagesToScan);
    }
}

