/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.disruptor.factory;

import com.livk.context.disruptor.factory.SpringEventFactory;
import com.livk.context.disruptor.factory.SpringEventHandlerFactory;
import com.livk.context.disruptor.factory.VirtualThreadFactory;
import com.livk.context.disruptor.support.DisruptorCustomizer;
import com.livk.context.disruptor.support.SpringDisruptor;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class DisruptorFactoryBean<T>
implements FactoryBean<SpringDisruptor<T>>,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private AnnotationAttributes attributes;
    private BeanFactory beanFactory;
    private SpringDisruptor<T> disruptor;
    private Class<T> type;

    public SpringDisruptor<T> getObject() {
        return this.disruptor;
    }

    public Class<?> getObjectType() {
        return SpringDisruptor.class;
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private ThreadFactory createThreadFactory() {
        String threadFactoryBeanName = this.attributes.getString("threadFactoryBeanName");
        if (StringUtils.hasText((String)threadFactoryBeanName)) {
            return (ThreadFactory)this.beanFactory.getBean(threadFactoryBeanName, ThreadFactory.class);
        }
        Class factoryClass = this.attributes.getClass("threadFactory");
        ThreadFactory threadFactory = (ThreadFactory)BeanUtils.instantiateClass((Class)factoryClass);
        return new VirtualThreadFactory(threadFactory);
    }

    private WaitStrategy createWaitStrategy() {
        String strategyBeanName = this.attributes.getString("strategyBeanName");
        if (StringUtils.hasText((String)strategyBeanName)) {
            return (WaitStrategy)this.beanFactory.getBean(strategyBeanName, WaitStrategy.class);
        }
        Class strategyClass = this.attributes.getClass("strategy");
        return (WaitStrategy)BeanUtils.instantiateClass((Class)strategyClass);
    }

    public void afterPropertiesSet() {
        SpringEventFactory factory = new SpringEventFactory();
        ResolvableType disruptorCustomizerType = ResolvableType.forClassWithGenerics(DisruptorCustomizer.class, (Class[])new Class[]{this.type});
        int bufferSize = this.attributes.getNumber("bufferSize").intValue();
        ProducerType producerType = (ProducerType)this.attributes.getEnum("type");
        this.disruptor = new SpringDisruptor(factory, bufferSize, this.createThreadFactory(), producerType, this.createWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{SpringEventHandlerFactory.create(this.beanFactory, this.type)});
        this.beanFactory.getBeanProvider(disruptorCustomizerType).forEach(customizer -> customizer.customize(this.disruptor));
        this.disruptor.start();
    }

    public void destroy() {
        this.disruptor.shutdown();
    }

    public void setAttributes(AnnotationAttributes attributes) {
        this.attributes = attributes;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }
}

