/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.disruptor.factory;

import com.livk.commons.beans.GenericWrapper;
import java.util.concurrent.ThreadFactory;
import org.springframework.lang.NonNull;

class VirtualThreadFactory
implements ThreadFactory,
GenericWrapper<ThreadFactory> {
    private final ThreadFactory delegate;

    @Override
    public Thread newThread(@NonNull Runnable r) {
        Thread.Builder builder = Thread.ofVirtual();
        if (r instanceof Thread) {
            Thread thread = (Thread)r;
            builder = builder.name(thread.getName() + "-virtual");
        }
        return builder.inheritInheritableThreadLocals(true).factory().newThread(this.delegate.newThread(r));
    }

    public ThreadFactory unwrap() {
        return this.delegate;
    }

    public VirtualThreadFactory(ThreadFactory delegate) {
        this.delegate = delegate;
    }
}

