/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.dynamic;

import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.core.NamedThreadLocal;
import org.springframework.util.StringUtils;

public class DataSourceContextHolder {
    private static final ThreadLocal<String> datasourceHolder = new NamedThreadLocal("datasource context");
    private static final ThreadLocal<String> inheritableDatasourceHolder = new NamedInheritableThreadLocal("inheritable datasource context");

    public static void switchDataSource(String datasource) {
        DataSourceContextHolder.switchDataSource(datasource, false);
    }

    public static void switchDataSource(String datasource, boolean inheritable) {
        if (StringUtils.hasText((String)datasource)) {
            if (inheritable) {
                inheritableDatasourceHolder.set(datasource);
                datasourceHolder.remove();
            } else {
                datasourceHolder.set(datasource);
                inheritableDatasourceHolder.remove();
            }
        } else {
            DataSourceContextHolder.clear();
        }
    }

    public static String getDataSource() {
        String datasource = datasourceHolder.get();
        return StringUtils.hasText((String)datasource) ? datasource : inheritableDatasourceHolder.get();
    }

    public static void clear() {
        datasourceHolder.remove();
        inheritableDatasourceHolder.remove();
    }
}

