/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.easyexcel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.livk.commons.io.ResourceUtils;
import com.livk.commons.util.BaseStreamUtils;
import com.livk.context.easyexcel.annotation.ResponseExcel;
import com.livk.context.easyexcel.listener.ExcelMapReadListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class EasyExcelSupport {
    private static final Logger log = LoggerFactory.getLogger(EasyExcelSupport.class);

    public static void read(InputStream in, Class<?> excelModelClass, ExcelMapReadListener<?> listener, Boolean ignoreEmptyRow) {
        try (ExcelReader excelReader = EasyExcel.read((InputStream)in, listener).ignoreEmptyRow(ignoreEmptyRow).build();){
            List<ReadSheet> readSheets = excelReader.excelExecutor().sheetList().stream().map(sheet -> ((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)sheet.getSheetNo(), (String)sheet.getSheetName()).head(excelModelClass)).build()).toList();
            excelReader.read(readSheets);
            excelReader.finish();
        }
    }

    public static void write(OutputStream outputStream, Class<?> excelModelClass, String location, Map<String, ? extends Collection<?>> result) {
        ExcelWriterBuilder builder = EasyExcel.write((OutputStream)outputStream);
        if (StringUtils.hasText((String)location)) {
            try {
                File file = ResourceUtils.getFile((String)location);
                builder.withTemplate(file);
                EasyExcelSupport.templateWrite(builder, result);
                return;
            }
            catch (FileNotFoundException e) {
                log.info("EasyExcel\u4f7f\u7528\u6a21\u677f\u9519\u8bef:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        builder.head(excelModelClass);
        EasyExcelSupport.ordinaryWrite(EasyExcel.write((OutputStream)outputStream, excelModelClass), result);
    }

    private static void ordinaryWrite(ExcelWriterBuilder builder, Map<String, ? extends Collection<?>> result) {
        try (ExcelWriter writer = builder.build();){
            for (Map.Entry<String, Collection<?>> entry : result.entrySet()) {
                WriteSheet sheet = EasyExcel.writerSheet((String)entry.getKey()).build();
                writer.write(entry.getValue(), sheet);
            }
            writer.finish();
        }
    }

    private static void templateWrite(ExcelWriterBuilder builder, Map<String, ? extends Collection<?>> result) {
        try (ExcelWriter writer = builder.build();){
            result.entrySet().forEach(BaseStreamUtils.forEachWithIndex((int)0, (entry, index) -> {
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)index, (String)((String)entry.getKey())).registerWriteHandler((WriteHandler)new SheetWriteHandler(){
                    final /* synthetic */ Integer val$index;
                    final /* synthetic */ Map.Entry val$entry;
                    {
                        this.val$index = n;
                        this.val$entry = entry;
                    }

                    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
                        writeWorkbookHolder.getCachedWorkbook().setSheetName(this.val$index.intValue(), (String)this.val$entry.getKey());
                    }
                })).build();
                writer.write((Collection)entry.getValue(), writeSheet);
            }));
            writer.finish();
        }
    }

    public static String fileName(ResponseExcel excelReturn) {
        String suffix;
        String template = excelReturn.template();
        if (StringUtils.hasText((String)template)) {
            int index = template.lastIndexOf(46);
            suffix = template.substring(index);
        } else {
            suffix = excelReturn.suffix().getName();
        }
        return excelReturn.fileName().concat(suffix);
    }

    private EasyExcelSupport() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

