/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.easyexcel.resolver;

import com.livk.commons.util.BeanUtils;
import com.livk.context.easyexcel.EasyExcelSupport;
import com.livk.context.easyexcel.ExcelDataType;
import com.livk.context.easyexcel.annotation.ExcelParam;
import com.livk.context.easyexcel.annotation.RequestExcel;
import com.livk.context.easyexcel.listener.ExcelMapReadListener;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

public class ExcelMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasMethodAnnotation(RequestExcel.class) && parameter.hasParameterAnnotation(ExcelParam.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, @NonNull NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RequestExcel excelImport = (RequestExcel)parameter.getMethodAnnotation(RequestExcel.class);
        ExcelParam excelParam = (ExcelParam)parameter.getParameterAnnotation(ExcelParam.class);
        if (Objects.nonNull(excelImport) && Objects.nonNull(excelParam)) {
            ExcelMapReadListener listener = (ExcelMapReadListener)BeanUtils.instantiateClass(excelImport.parse());
            HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
            InputStream in = this.getInputStream(request, excelParam.fileName());
            ExcelDataType dataType = ExcelDataType.match(parameter.getParameterType());
            Class<?> excelModelClass = dataType.getFunction().apply(ResolvableType.forMethodParameter((MethodParameter)parameter));
            EasyExcelSupport.read(in, excelModelClass, listener, excelImport.ignoreEmptyRow());
            return listener.getData(dataType);
        }
        throw new IllegalArgumentException("Excel upload request resolver error, @ExcelData parameter type error");
    }

    private InputStream getInputStream(HttpServletRequest request, String fileName) throws IOException {
        if (request instanceof MultipartRequest) {
            MultipartRequest multipartRequest = (MultipartRequest)request;
            MultipartFile file = multipartRequest.getFile(fileName);
            Assert.notNull((Object)file, (String)"file not be null");
            return file.getInputStream();
        }
        return null;
    }
}

