/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.easyexcel.resolver;

import com.livk.commons.util.AnnotationUtils;
import com.livk.context.easyexcel.EasyExcelSupport;
import com.livk.context.easyexcel.annotation.ResponseExcel;
import com.livk.context.easyexcel.exception.ExcelExportException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaTypeFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.ErrorResponseException;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ExcelMethodReturnValueHandler
implements AsyncHandlerMethodReturnValueHandler {
    public static final String UTF8 = "UTF-8";

    public boolean supportsReturnType(@NonNull MethodParameter returnType) {
        return AnnotationUtils.hasAnnotationElement((MethodParameter)returnType, ResponseExcel.class);
    }

    public void handleReturnValue(Object returnValue, @NonNull MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) {
        mavContainer.setRequestHandled(true);
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        ResponseExcel excelReturn = (ResponseExcel)AnnotationUtils.getAnnotationElement((MethodParameter)returnType, ResponseExcel.class);
        Assert.notNull((Object)response, (String)"response not be null");
        Assert.notNull((Object)excelReturn, (String)"excelReturn not be null");
        if (returnValue instanceof Collection) {
            Class excelModelClass = ResolvableType.forMethodParameter((MethodParameter)returnType).resolveGeneric(new int[]{0});
            this.write(excelReturn, response, excelModelClass, Map.of("sheet", (Collection)returnValue));
        } else if (returnValue instanceof Map) {
            Map result = (Map)returnValue;
            Class excelModelClass = ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[]{1}).resolveGeneric(new int[]{0});
            this.write(excelReturn, response, excelModelClass, result);
        } else {
            throw new ExcelExportException("the return class is not java.util.Collection or java.util.Map");
        }
    }

    private void write(ResponseExcel excelReturn, HttpServletResponse response, Class<?> excelModelClass, Map<String, Collection<?>> result) {
        this.setResponse(excelReturn, response);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            EasyExcelSupport.write((OutputStream)outputStream, excelModelClass, excelReturn.template(), result);
        }
        catch (IOException e) {
            throw new ErrorResponseException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private void setResponse(ResponseExcel excelReturn, HttpServletResponse response) {
        String fileName = EasyExcelSupport.fileName(excelReturn);
        String contentType = MediaTypeFactory.getMediaType((String)fileName).map(MimeType::toString).orElse("application/vnd.ms-excel");
        response.setContentType(contentType);
        response.setCharacterEncoding(UTF8);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
    }

    public boolean isAsyncReturnValue(Object returnValue, @NonNull MethodParameter returnType) {
        return AnnotationUtils.hasAnnotationElement((MethodParameter)returnType, ResponseExcel.class);
    }
}

