/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.easyexcel.resolver;

import com.livk.commons.io.DataBufferUtils;
import com.livk.commons.io.FileUtils;
import com.livk.commons.util.BeanUtils;
import com.livk.context.easyexcel.EasyExcelSupport;
import com.livk.context.easyexcel.ExcelDataType;
import com.livk.context.easyexcel.annotation.ExcelParam;
import com.livk.context.easyexcel.annotation.RequestExcel;
import com.livk.context.easyexcel.listener.ExcelMapReadListener;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.codec.multipart.Part;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveExcelMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ReactiveAdapterRegistry adapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasMethodAnnotation(RequestExcel.class) && parameter.hasParameterAnnotation(ExcelParam.class);
    }

    @NonNull
    public Mono<Object> resolveArgument(@NonNull MethodParameter parameter, @NonNull BindingContext bindingContext, @NonNull ServerWebExchange exchange) {
        Class resolvedType = ResolvableType.forMethodParameter((MethodParameter)parameter).resolve();
        ReactiveAdapter adapter = resolvedType != null ? this.adapterRegistry.getAdapter(resolvedType) : null;
        RequestExcel excelImport = (RequestExcel)parameter.getMethodAnnotation(RequestExcel.class);
        ExcelParam excelParam = (ExcelParam)parameter.getParameterAnnotation(ExcelParam.class);
        Mono mono = Mono.empty();
        if (Objects.nonNull(excelImport) && Objects.nonNull(excelParam)) {
            ExcelMapReadListener listener = (ExcelMapReadListener)BeanUtils.instantiateClass(excelImport.parse());
            ResolvableType genericType = ResolvableType.forMethodParameter((MethodParameter)parameter);
            if (parameter.getParameterType().equals(Mono.class)) {
                genericType = genericType.getGeneric(new int[]{0});
            }
            if (genericType.getRawClass() != null) {
                ExcelDataType dataType = Flux.class.isAssignableFrom(genericType.getRawClass()) ? ExcelDataType.COLLECTION : ExcelDataType.match(genericType.getRawClass());
                Class<?> excelModelClass = dataType.getFunction().apply(genericType);
                mono = FileUtils.getPartValues((String)excelParam.fileName(), (ServerWebExchange)exchange).map(Part::content).flatMap(DataBufferUtils::transform).doOnSuccess(in -> EasyExcelSupport.read(in, excelModelClass, listener, excelImport.ignoreEmptyRow())).map(in -> listener.getData(dataType));
            }
        }
        return adapter != null ? Mono.just((Object)adapter.fromPublisher((Publisher)mono)) : Mono.from((Publisher)mono);
    }
}

