/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.easyexcel.resolver;

import com.livk.commons.io.DataBufferUtils;
import com.livk.commons.util.AnnotationUtils;
import com.livk.context.easyexcel.EasyExcelSupport;
import com.livk.context.easyexcel.annotation.ResponseExcel;
import com.livk.context.easyexcel.exception.ExcelExportException;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveExcelMethodReturnValueHandler
implements HandlerResultHandler,
Ordered {
    public static final MediaType EXCEL_MEDIA_TYPE = new MediaType("application", "vnd.ms-excel");
    private static final Function<Collection<?>, Map<String, Collection<?>>> defaultFunction = c -> Map.of("sheet", c);
    private final ReactiveAdapterRegistry adapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

    public boolean supports(@NonNull HandlerResult result) {
        return AnnotationUtils.hasAnnotationElement((MethodParameter)result.getReturnTypeSource(), ResponseExcel.class);
    }

    @NonNull
    public Mono<Void> handleResult(@NonNull ServerWebExchange exchange, HandlerResult result) {
        Object returnValue = result.getReturnValue();
        if (returnValue == null) {
            return Mono.empty();
        }
        ResponseExcel excelReturn = (ResponseExcel)AnnotationUtils.getAnnotationElement((MethodParameter)result.getReturnTypeSource(), ResponseExcel.class);
        ServerHttpResponse response = exchange.getResponse();
        ResolvableType returnType = result.getReturnType();
        ReactiveAdapter adapter = this.adapterRegistry.getAdapter(returnType.resolve(), returnValue);
        if (adapter != null) {
            ResolvableType genericType = returnType.getGeneric(new int[0]);
            if (Flux.class.isAssignableFrom(returnType.toClass())) {
                Class excelModelClass = genericType.toClass();
                Flux flux = (Flux)returnValue;
                Mono mono = flux.collectList().map(defaultFunction);
                return this.write(excelReturn, response, excelModelClass, mono);
            }
            if (Mono.class.isAssignableFrom(returnType.toClass())) {
                if (Collection.class.isAssignableFrom(genericType.toClass())) {
                    Class excelModelClass = genericType.resolveGeneric(new int[]{0});
                    Mono mono = ((Mono)returnValue).map(defaultFunction);
                    return this.write(excelReturn, response, excelModelClass, mono);
                }
                if (Map.class.isAssignableFrom(genericType.toClass())) {
                    Class excelModelClass = genericType.getGeneric(new int[]{1}).resolveGeneric(new int[]{0});
                    Mono mono = (Mono)returnValue;
                    return this.write(excelReturn, response, excelModelClass, mono);
                }
                throw new ExcelExportException("the return class is not java.util.Collection or java.util.Map");
            }
            throw new ExcelExportException("the return class is not reactor.core.publisher.Flux or reactor.core.publisher.Mono");
        }
        if (Collection.class.isAssignableFrom(returnType.toClass())) {
            Class excelModelClass = returnType.resolveGeneric(new int[]{0});
            return this.write(excelReturn, response, excelModelClass, defaultFunction.apply((Collection)returnValue));
        }
        if (Map.class.isAssignableFrom(returnType.toClass())) {
            Map map = (Map)returnValue;
            Class excelModelClass = returnType.getGeneric(new int[]{1}).resolveGeneric(new int[]{0});
            return this.write(excelReturn, response, excelModelClass, map);
        }
        throw new ExcelExportException("the return class is not java.util.Collection or java.util.Map");
    }

    private Mono<Void> write(ResponseExcel excelReturn, ServerHttpResponse response, Class<?> excelModelClass, Mono<Map<String, Collection<?>>> result) {
        return result.flatMap(r -> this.write(excelReturn, response, excelModelClass, (Map<String, Collection<?>>)r));
    }

    private Mono<Void> write(ResponseExcel excelReturn, ServerHttpResponse response, Class<?> excelModelClass, Map<String, Collection<?>> result) {
        this.setResponse(excelReturn, response);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EasyExcelSupport.write(outputStream, excelModelClass, excelReturn.template(), result);
        Flux bufferFlux = DataBufferUtils.transform((byte[])outputStream.toByteArray());
        return response.writeWith((Publisher)bufferFlux);
    }

    private void setResponse(ResponseExcel excelReturn, ServerHttpResponse response) {
        String fileName = EasyExcelSupport.fileName(excelReturn);
        MediaType mediaType = MediaTypeFactory.getMediaType((String)fileName).orElse(EXCEL_MEDIA_TYPE);
        HttpHeaders headers = response.getHeaders();
        headers.setContentType(mediaType);
        headers.setAcceptCharset(List.of(StandardCharsets.UTF_8));
        ContentDisposition contentDisposition = ContentDisposition.parse((String)("attachment;filename=" + fileName));
        headers.setContentDisposition(contentDisposition);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

