/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.limit;

import com.livk.commons.expression.ExpressionResolver;
import com.livk.commons.expression.spring.SpringExpressionResolver;
import com.livk.commons.util.WebUtils;
import com.livk.context.limit.LimitExecutor;
import com.livk.context.limit.annotation.Limit;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class LimitSupport {
    private final ExpressionResolver resolver = new SpringExpressionResolver();
    private final LimitExecutor limitExecutor;

    public boolean exec(Limit limit, Method method, Object[] args) {
        String key = limit.key();
        int rate = limit.rate();
        int rateInterval = limit.rateInterval();
        TimeUnit rateIntervalUnit = limit.rateIntervalUnit();
        Object spELKey = this.resolver.evaluate(key, method, args);
        if (limit.restrictIp()) {
            String ip = WebUtils.realIp((HttpServletRequest)WebUtils.request());
            spELKey = (String)spELKey + "#" + ip;
        }
        return this.limitExecutor.tryAccess((String)spELKey, rate, rateInterval, rateIntervalUnit);
    }

    private LimitSupport(LimitExecutor limitExecutor) {
        this.limitExecutor = limitExecutor;
    }

    public static LimitSupport of(LimitExecutor limitExecutor) {
        return new LimitSupport(limitExecutor);
    }
}

