/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.limit.executor;

import com.livk.context.limit.LimitExecutor;
import com.livk.context.limit.exception.LimitException;
import com.livk.context.limit.executor.ReentrantLimitExecutor;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RedissonLimitExecutor
extends ReentrantLimitExecutor
implements LimitExecutor {
    private static final Logger log = LoggerFactory.getLogger(RedissonLimitExecutor.class);
    private final RedissonClient redissonClient;

    @Override
    protected boolean reentrantTryAccess(String compositeKey, int rate, int rateInterval, TimeUnit rateIntervalUnit) {
        if (StringUtils.hasText((String)compositeKey)) {
            RRateLimiter rateLimiter = this.redissonClient.getRateLimiter(compositeKey);
            try {
                RateIntervalUnit unit = RateIntervalUnit.valueOf((String)rateIntervalUnit.name());
                rateLimiter.trySetRate(RateType.OVERALL, (long)rate, (long)rateInterval, unit);
                return rateLimiter.tryAcquire(1L);
            }
            catch (Exception e) {
                throw new LimitException("un support TimeUnit " + String.valueOf((Object)rateIntervalUnit), e);
            }
        }
        throw new LimitException("Composite key is null or empty");
    }

    public RedissonLimitExecutor(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

