/*
 * Decompiled with CFR 0.152.
 */
package com.livk.context.limit.interceptor;

import com.livk.commons.aop.AnnotationAbstractPointcutTypeAdvisor;
import com.livk.context.limit.LimitExecutor;
import com.livk.context.limit.LimitSupport;
import com.livk.context.limit.annotation.Limit;
import com.livk.context.limit.exception.LimitException;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class LimitInterceptor
extends AnnotationAbstractPointcutTypeAdvisor<Limit> {
    private static final Logger log = LoggerFactory.getLogger(LimitInterceptor.class);
    private final ObjectProvider<LimitExecutor> provider;

    protected Object invoke(MethodInvocation invocation, Limit limit) throws Throwable {
        LimitSupport limitSupport = LimitSupport.of((LimitExecutor)this.provider.getIfAvailable());
        boolean status = limitSupport.exec(limit, invocation.getMethod(), invocation.getArguments());
        if (status) {
            return invocation.proceed();
        }
        throw new LimitException("key=" + limit.key() + " is reach max limited access count=" + limit.rate() + " within period=" + limit.rateInterval() + " " + limit.rateIntervalUnit().name());
    }

    public LimitInterceptor(ObjectProvider<LimitExecutor> provider) {
        this.provider = provider;
    }
}

